
// Single generic node for the BSTree
public class BSTreeNode<K,E> {
	private K key;		// Key
	private E element;	// Value
	private BSTreeNode<K,E> left;	// Left child
	private BSTreeNode<K,E> right;	// Right child
	
	// Empty constructor
	public BSTreeNode() {
		setLeft(setRight(null));
	}
	
	// Constructor given key value pair
	public BSTreeNode(K k, E e) {
		setLeft(setRight(null));
		setKey(k);
		setElement(e);
	}
	
	// Constructor given key value pair and children
	public BSTreeNode(K k, E e, BSTreeNode<K,E> left, BSTreeNode<K,E> right) {
		setKey(k);
		setElement(e);
		this.setLeft(left);
		this.setRight(right);
	}
	
	// Query if node has leaves
	public boolean isLeaf() {
		return left == null && right == null;
	}
	
	// Encapsulation methods
	public K getKey() {
		return key;
	}
	public void setKey(K key) {
		this.key = key;
	}
	public E getElement() {
		return element;
	}
	public void setElement(E element) {
		this.element = element;
	}
	public BSTreeNode<K,E> getLeft() {
		return left;
	}
	public void setLeft(BSTreeNode<K,E> left) {
		this.left = left;
	}
	public BSTreeNode<K,E> getRight() {
		return right;
	}
	public BSTreeNode<K,E> setRight(BSTreeNode<K,E> right) {
		this.right = right;
		return right;
	}
}
